//
//  BPOfflineSyncWindow.h
//  BIViews
//
//  Created by Alykhan Jetha on 10-04-22.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <MCApplication/MCWindowController.h>


@interface BPOfflineSyncWindow : MCWindowController {
	IBOutlet NSProgressIndicator *indicator;
	BOOL isModalSheet;
	
	BOOL syncFailed;
	BOOL stopModalSession;
	
	NSString *message;
	NSString *title;
	
}

@property (retain) NSString *message;
@property (retain) NSString *title;

+ (BPOfflineSyncWindow *)sharedOfflineSyncWindow;

/*!
 Checks server availability and reports to the user if not available
 */
+ (BOOL)canSync;


/*!
 Runs the sync in application modal state. Returns OK or CANCEL
 */
+ (NSInteger)sync;
+ (NSInteger)syncWithMessage:(NSString *)aMessage title:(NSString *)aTitle;
+ (void)syncAsSheetInWindow:(NSWindow *)aWindow;
+ (void)syncAsSheetInWindow:(NSWindow *)aWindow message:(NSString *)aMessage title:(NSString *)aTitle;


/*!
 Returns NSOKButton or NSCancelButton
 */
- (NSInteger)runModal;

@end
